

/**********************************************************************************************
 *                                                                                            *
 * Ex3.      :  Sent Command Control ON/OFF 7-Segment (RL)                                    *
 *                                                                                            *
 **********************************************************************************************
 *                                                                                            *
 * Target MCU        : PIC18F8722 (ET-BASE PIC8722(ICD2))                                     *
 *                   : X-TAL : 10 MHz                                                         *
 *                   : CPU Clock = 40 MHz (x4)                                                *  
 *                                                                                            *
 * Editor-Compiler   : CCS Version 4.124                                                      *
 *                                                                                            *
 * Create By         : Mr. Sittiphol Yooyod (WWW.ETT.CO.TH)                                   *
 * Last Update       : 10/October/2014                                                        *
 *                                                                                            *
 * Port Interface    :  -- MCU-PIC-18F8722--           ---- ET-REMOTE DISTANCE ----           *
 *                                                                                            *
 *  UART1(soft ware) :  RC6 = TX1          Connect         Rx(RS232 Port)                     *
 *                      RC7 = RX1          Connect         Tx(RS232 Port)                     *
 *                                                                                            *
 *                                                         Set JP-TTL/RS232 to RS232          *
 *                    Baud Rate = 57600 at Clock 40 Mhz    Set JP-BR (57600)                  *
 *                                                         Disable Filter                     *
 *                                                                                            *
 *                                                                                            *
 *  Operation    :  Control 7-Segment on Module ON/OFF Every  2 Sec                           *                                                           
 *                                                                                            *
 **********************************************************************************************/
 

#include <18F8722.h>
#include <stdio.h>

#define TX1   PIN_C6
#define RX1   PIN_C7

#fuses H4,NOLVP,NOWDT,NOPROTECT,NOSTVREN          //Setup MCU
#use delay (clock = 40000000)                     //delay Clock = (ms)

#use rs232(baud = 57600, xmit = TX1, rcv = RX1)   //Set Rs232-CH1

#use fast_io(ALL)                                 //Stop Set direction Auto for All Port  by Compiler  


void Check_Echo_Cmm(void) ;


//-------------- Recive Echo Command ----------------

void Check_Echo_Cmm(void)
 {
   int8 ch ;  
   
     do
     {
        ch = getc()                             ; //Read data Start Byte
        
     }while(ch != '#')                          ; //Check Byte Start of Echo cmm('#')
 
    do
     {
        ch = getc()                             ; //Read data
     }while(ch != 0x0D)                         ; //Check Byte End of Echo cmm(0x0D)
 }


/*****************************************
 **       Function Initial UART1        **
 *****************************************/

void UART1_Init(void)
 {
   set_tris_C(0x80)             ;        //Set RX(RC7) = In,TX(RC6)=Out,RC5..RC0 = Out

 }

/********************************************************
 **                                                    **
 **                        MAIN                        **   
 **                                                    **
 ********************************************************/

 void main (void) 
  {
    unsigned int8 enter = 0x0D          ;
       
  
    UART1_Init()                        ;       //Initial Uart1 
    
    delay_ms(2000)                      ;       //Wait Module ET-Remote Distance Ready when Power On

//----------------- Start Sent Command Control ON/OFF 7-Segment On Module --------------

    while(true) 
    {   
      //################---- Sent Command RL ----#################
     
      printf("*RL=%c",enter)                      ;  //Sent Command ON/OFF 7-Segment(Command Control 7-Seg fomat Toggle)   
      
      Check_Echo_Cmm()                            ;  //Wait Echo Command for Sent Next Command
           
      delay_ms(2000)                              ;  //delay 2 Second

    }//while

  }

